local curStage = GAMESTATE:GetCurrentStage()
local playMode = GAMESTATE:GetPlayMode()
local course = GAMESTATE:GetCurrentCourse()

if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
	curStage = playMode;
end;

local t = Def.ActorFrame {};
	t[#t+1] = LoadActor("bg") .. {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffusealpha,0;);
		OnCommand=cmd(sleep,0.5;diffusealpha,1;);
	};
	
	t[#t+1] = LoadActor("sparklesparkle") .. {
		InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X-140;y,SCREEN_CENTER_Y;diffusealpha,0;zoom,0.5;);
		OnCommand=cmd(blend,"BlendMode_Add";sleep,2.6;diffusealpha,1;smooth,0.4;zoom,1.5;diffusealpha,0);
	};
	
	
	t[#t+1] = Def.ActorFrame {
    InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X-40;y,SCREEN_CENTER_Y-20;diffusealpha,0;);
	LoadActor(THEME:GetPathG("ScreenStageInformation", "stage " .. ToEnumShortString(curStage) ) ) .. {
		OnCommand=cmd(sleep,2.6;smooth,0.6;diffusealpha,1;addx,174;);
		};
	};
	
	if GAMESTATE:IsCourseMode() then
		t[#t+1] = Def.Sprite {
		  BeginCommand=function(self)
			local sPath = THEME:GetPathG("Common","Fallback Banner"); -- use variable so we always have a fallback
			if course:GetCurrentSong() then
			  sPath = course:GetCurrentSong():GetBannerPath()
			else
			  return
			end
			-- 
			self:LoadBanner(sPath);
		  end;
		  InitCommand=cmd(Center;cropto,256,256;shadowlength,1;diffusealpha,0);
		  OnCommand=cmd(sleep,0.5;zoom,2.0;sleep,1.5;smooth,0.4;zoom,0.75;diffusealpha,1;decelerate,0.7;addx,-170;sleep,1.5;);
		  OffCommand=cmd(;);
		};
	else
		t[#t+1] = Def.Sprite {
		  BeginCommand=function(self)
			local sPath = THEME:GetPathG("Common","Fallback Banner"); -- use variable so we always have a fallback
			if GAMESTATE:GetCurrentSong() then
			  sPath = GAMESTATE:GetCurrentSong():GetBannerPath()
			else
			  return
			end
			-- 
			self:LoadBanner(sPath);
		  end;
		  InitCommand=cmd(Center;cropto,256,256;shadowlength,1;diffusealpha,0);
		  OnCommand=cmd(sleep,0.5;zoom,2.0;sleep,1.5;smooth,0.4;zoom,0.75;diffusealpha,1;decelerate,0.7;addx,-170;sleep,1.5;);
		  OffCommand=cmd(;);
		};
	end

	
	t[#t+1] = Def.ActorFrame {
	  InitCommand=cmd(x,SCREEN_CENTER_X+107;y,SCREEN_CENTER_Y+56);
		LoadFont("Common Normal") .. {
			Text=GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() or GAMESTATE:GetCurrentSong():GetDisplayFullTitle();
			InitCommand=cmd(strokecolor,Color("Outline");y,-20;maxwidth,300);
			OnCommand=cmd(diffusealpha,0;sleep,2.6;linear,0.6;diffusealpha,1;addy,10;sleep,1.5;);
		};
		LoadFont("Common Normal") .. {
			Text=GAMESTATE:IsCourseMode() and ToEnumShortString( GAMESTATE:GetCurrentCourse():GetCourseType() ) or GAMESTATE:GetCurrentSong():GetDisplayArtist();
			InitCommand=cmd(strokecolor,Color("Outline");zoom,0.75);
			OnCommand=cmd(diffusealpha,0;sleep,2.6;linear,0.6;diffusealpha,1;addy,10;sleep,1.5;);
		};
	};	
	
	t[#t+1] = Def.Quad {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffusealpha,0);
		OnCommand=cmd(sleep,0.5;diffuse,color("#FFFFFF");smooth,0.5;diffusealpha,0);
	};


return t